

<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Localizations')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">

            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('Languages')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('admin.languages.index')); ?>"><?php echo e(localize('Languages')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e($language->name); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-12">
                    <div class="card mb-4" id="section-1">
                        <form class="app-search" action="<?php echo e(Request::fullUrl()); ?>" method="GET">
                            <div class="card-header border-bottom-0">
                                <div class="row justify-content-between g-3">
                                    <div class="col-auto flex-grow-1">
                                        <div class="tt-search-box">
                                            <div class="input-group">
                                                <span class="position-absolute top-50 start-0 translate-middle-y ms-2"> <i
                                                        data-feather="search"></i></span>
                                                <input class="form-control rounded-start w-100" type="text"
                                                    id="search" name="search" placeholder="<?php echo e(localize('Search')); ?>..."
                                                    <?php if(isset($searchKey)): ?>
                                        value="<?php echo e($searchKey); ?>"
                                        <?php endif; ?>>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <button type="submit" class="btn btn-primary">
                                            <i data-feather="search" width="18"></i>
                                            <?php echo e(localize('Search')); ?>

                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <form class="form-horizontal" action="<?php echo e(route('admin.languages.key_value_store')); ?>"
                            method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" value="<?php echo e($language->id); ?>">
                            <table class="table tt-footable table-hover border-top" data-use-parent-width="true"
                                id="localization-table">
                                <thead class="py-3">
                                    <tr>
                                        <th class="text-center py-3" width="5%"><?php echo e(localize('S/L')); ?>

                                        </th>
                                        <th width="40%" class="py-3"><?php echo e(localize('Lang Key')); ?></th>
                                        <th data-breakpoints="xs sm" class="py-3"><?php echo e(localize('Localizations')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $localizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $localization): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center align-middle">
                                                <?php echo e($key + 1 + ($localizations->currentPage() - 1) * $localizations->perPage()); ?>

                                            </td>

                                            <td class="align-middle">
                                                <a class="d-flex align-items-center">
                                                    <h6 class="fs-sm mb-0 key"><?php echo e($localization->t_value); ?></h6>
                                                </a>
                                            </td>
                                            <td class="align-middle">
                                                <input type="text" class="form-control value w-100"
                                                    name="values[<?php echo e($localization->t_key); ?>]"
                                                    placeholder="<?php echo e(localize('Type localization here')); ?>"
                                                    <?php if(($localization_lang = \App\Models\Localization::where('lang_key', $language->code)->where('t_key', $localization->t_key)->latest()->first()) != null): ?> value="<?php echo e($localization_lang->t_value); ?>" <?php endif; ?>>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>


                            <!--pagination start-->
                            <div class="d-flex align-items-center justify-content-between px-4 pb-4">
                                <nav>
                                    <?php echo e($localizations->appends(request()->input())->links()); ?>

                                </nav>
                                <div>
                                    <button type="button" class="btn btn-secondary"
                                        onclick="copyLocalizations()"><?php echo e(localize('Copy Localizations')); ?></button>
                                    <button type="submit" class="btn btn-primary"><?php echo e(localize('Save')); ?></button>
                                </div>
                            </div>
                            <!--pagination end-->
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        "use strict";

        //localize in one click
        function copyLocalizations() {
            $('#localization-table > tbody  > tr').each(function(index, tr) {
                $(tr).find('.value').val($(tr).find('.key').text());
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\baleaspirasi\resources\views/backend/pages/systemSettings/languageLocalizations.blade.php ENDPATH**/ ?>