<?php
    $user = auth()->user();
    $theme_mode = !empty($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';
?>
<aside class="tt-sidebar bg-light-subtle <?php echo e(Route::is('blog.wizard.create') ? 'collapse' : ''); ?>" id="sidebar">
    <div class="tt-brand">
        <a href="<?php echo e(route('writebot.dashboard')); ?>" class="tt-brand-link">
            <img src="<?php echo e(uploadedAsset(getSetting('favicon'))); ?>" id="favicon_backend" class="tt-brand-favicon ms-1 d-none"
                alt="favicon" width="30" />

            <?php if($theme_mode == 'dark'): ?>
                <img src="<?php echo e(uploadedAsset(getSetting('admin_panel_logo_dark') ?? getSetting('admin_panel_logo'))); ?>"
                    class="tt-brand-logo ms-2" alt="logo" />
            <?php else: ?>
                <img src="<?php echo e(uploadedAsset(getSetting('admin_panel_logo'))); ?>" class="tt-brand-logo ms-2"
                    alt="logo" />
            <?php endif; ?>
        </a>
        <a href="javascript:void(0);" class="tt-toggle-sidebar">
            <span><i data-feather="chevron-left"></i></span>
        </a>
    </div>

    <div class="tt-sidebar-nav pb-9 pt-3 d-flex flex-column h-100 justify-content-between">
        <nav class="navbar navbar-vertical navbar-expand-lg" data-simplebar>
            <div class="collapse navbar-collapse" id="navbarVerticalCollapse">
                <div class="w-100" id="leftside-menu-container">
                    <?php if(isCustomer()): ?>
                        <?php echo $__env->make('backend.inc.userSidebarMenus', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('backend.inc.sidebarMenus', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </nav>


        <ul class="tt-side-nav m-3 tt-user-side-nav">


            <!-- customer profile with affiliate link button -->
            <?php if(isCustomer()): ?>
                <li class="side-nav-item nav-item tt-sidebar-user rounded-3 bg-secondary-subtle">
                    <div class="side-nav-link flex-column justify-content-center py-4">
                        <div class="tt-user-avatar lh-1 mb-2">
                            <div class="avatar avatar-md status-online">
                                <img class="rounded-circle" src="<?php echo e(uploadedAsset($user->avatar)); ?>" alt=""
                                    onerror="this.onerror=null;this.src='<?php echo e(staticAsset('/backend/assets/img/avatar/1.jpg')); ?>';">
                            </div>
                        </div>
                        <div class="tt-nav-link-text text-center">
                            <h6 class="mb-0 lh-1 d-block"><?php echo e($user->name); ?></h6>
                            <span class="text-muted fs-sm"><?php echo e(optional(activePackageHistory())->title); ?></span>

                            <?php if(getSetting('enable_affiliate_system') == '1'): ?>
                                <div class="mt-3">
                                    <p class="text-muted fs-md">
                                        💰 <?php echo e(localize('Invite your friends and earn money from their subscriptions')); ?>

                                    </p>
                                    <a href="<?php echo e(route('affiliate.overview')); ?>"
                                        class="btn btn-accent btn-sm rounded-pill shadow-sm"><?php echo e(localize('Invite Friends')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </li>
            <?php else: ?>
                <!-- logout button for admin -->
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('logout')); ?>"
                        class="side-nav-link justify-content-center btn btn-accent rounded-pill text-center">
                        <?php echo e(localize('Logout')); ?> <i data-feather="log-out" class="icon-14 ms-2"></i>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</aside>
<?php /**PATH E:\xampp\htdocs\ai\baleaspirasi\resources\views/backend/inc/leftSidebar.blade.php ENDPATH**/ ?>