<!DOCTYPE html>
<?php
    $locale = str_replace('_', '-', app()->getLocale()) ?? 'en';
    $localLang = \App\Models\Language::where('code', $locale)->first();
?>

<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" data-bs-theme="<?php echo e(!empty($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light'); ?>">

<head>
    <!--required meta tags-->
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php if(!empty($_SERVER['HTTPS'])): ?>
        <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests" />
    <?php endif; ?>

    <!--favicon icon-->
    <link rel="shortcut icon" href="<?php echo e(uploadedAsset(getSetting('favicon'))); ?>">

    <!--title-->
    <title>
        <?php echo $__env->yieldContent('title'); ?>

    </title>

    <?php if(env('ENABLE_GOOGLE_ANALYTICS') == 1): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(env('TRACKING_ID')); ?>"></script>

        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo e(env('TRACKING_ID')); ?>');
        </script>
    <?php endif; ?>


    <!--build:css-->
    <?php echo $__env->make('backend.inc.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- end build -->

    <?php
        echo getSetting('header_custom_css');
    ?>

    <?php
        echo  getSetting('header_custom_scripts');
    ?>
        <?php echo $__env->yieldPushContent('styles'); ?>

    <?php echo $__env->yieldContent("css"); ?>
<?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>
</head>

<body>
    <input type="hidden" name="url" id="url" value="">
    <!--preloader start-->
    <?php if(getSetting('enable_preloader') != '0'): ?>
        <div id="preloader" class="bg-light-subtle">
            <div class="preloader-wrap">
                <img src="<?php echo e(uploadedAsset(getSetting('navbar_logo_dark'))); ?>" class="img-fluid">
                <div class="loading-bar"></div>
            </div>
        </div>
    <?php endif; ?>
    <!--preloader end-->

    <!--sidebar section start-->
    <?php echo $__env->make('backend.inc.leftSidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--sidebar section end-->

    <!--main content wrapper start-->
    <main class="tt-main-wrapper bg-secondary-subtle" id="content">

        <!--header section start-->
        <?php echo $__env->make('backend.inc.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--header section end-->

        <!-- Start Content-->
        <?php echo $__env->yieldContent('contents'); ?>
        <!-- container -->

        <!--footer section start-->
        <?php echo $__env->make('backend.inc.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--footer section end-->

        <!-- media-manager -->
        <?php echo $__env->make('backend.inc.media-manager.media-manager', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </main>
    <!--main content wrapper end-->

    <!-- modals -->
    <?php echo $__env->yieldContent('modals'); ?>

    <!-- modals for common layout - website-admin -->
    <?php echo $__env->yieldContent('modals-common'); ?>

    <!-- delete modal -->
    <?php echo $__env->make('backend.inc.deleteModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- delete modal -->
    <?php echo $__env->make('backend.inc.deleteAllModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- hide modal -->
    <?php echo $__env->make('backend.inc.hideModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- approve modal -->
    <?php echo $__env->make('backend.inc.approveModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- reject modal -->
    <?php echo $__env->make('backend.inc.rejectModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- reSubmit modal -->
    <?php echo $__env->make('backend.inc.reSubmitModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




    <!--build:js-->
    <?php echo $__env->make('backend.inc.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--endbuild-->
    <!-- required scripts -->
    <script>
        "use strict";

        // scroll
        function initScrollToChatBottom() {
            var ChatDiv = $(".tt-conversation");
            var height = ChatDiv[0]?.scrollHeight;
            ChatDiv.scrollTop(height);
        }

        // change language
        function changeLocaleLanguage(e) {
            var locale = e.dataset.flag;
            $.post("<?php echo e(route('backend.changeLanguage')); ?>", {
                _token: '<?php echo e(csrf_token()); ?>',
                locale: locale
            }, function(data) {
                location.reload();
            });
        }


        // change currency
        function changeLocaleCurrency(e) {
            var currency_code = e.dataset.currency;
            $.post("<?php echo e(route('backend.changeCurrency')); ?>", {
                _token: '<?php echo e(csrf_token()); ?>',
                currency_code: currency_code
            }, function(data) {
                location.reload();
            });
        }

        // localize data
        function localizeData(langKey) {
            window.location = '<?php echo e(url()->current()); ?>?lang_key=' + langKey + '&localize';
        }

        // ajax toast
        function notifyMe(level, message) {
            if (level == 'danger') {
                level = 'error';
            }
            toastr.options = {
                closeButton: true,
                newestOnTop: false,
                progressBar: true,
                positionClass: "toast-top-center",
                preventDuplicates: false,
                onclick: null,
                showDuration: "3000",
                hideDuration: "1000",
                timeOut: "2500",
                extendedTimeOut: "1000",
                showEasing: "swing",
                hideEasing: "linear",
                showMethod: "fadeIn",
                hideMethod: "fadeOut",
            };
            toastr[level](message);
        }

        //laravel flash toast messages
        <?php $__currentLoopData = session('flash_notification', collect())->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        notifyMe("<?php echo e($message['level']); ?>", "<?php echo e($message['message']); ?>");
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    </script>

    <!-- scripts from different pages -->
    <?php echo $__env->yieldContent('scripts'); ?>

    <!-- scripts for common layout - website-admin -->
    <?php echo $__env->yieldContent('scripts-common'); ?>

    <?php
        echo  getSetting('footer_custom_scripts') ;
    ?>

</body>

</html>
<?php /**PATH E:\xampp\htdocs\ai\baleaspirasi\resources\views/backend/layouts/master.blade.php ENDPATH**/ ?>