<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PdfChatConversation extends Model
{
    use HasFactory;
    protected $table = "pdf_chat_conversations";
    protected $fillable = [
        "user_id", "pdf_chat_id", "pdf_file", "prompt", "pdf_content", "pdf_embedding_content",
        "prompt_embedding_content", "ai_response", "words", "prompt_tokens", "total_used_tokens"
    ];

    protected $casts = [
        "prompt_embedding_content" => "array",
        "pdf_embedding_content" => "array"
    ];

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        static::creating(function ($model) {
            $model->user_id = userId();
        });
    }

    public function pdfChat() : BelongsTo
    {
        return $this->belongsTo(PdfChat::class,"pdf_chat_id");
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class,"user_id");
    }

    public function scopeUserId($query, $user_id = null){
        $user_id = empty($user_id) ? userId() : $user_id;
        $query->where('user_id', $user_id);
    }

    public function scopeChatCode($query, $chatCode){
        $query->where('chat_code', $chatCode);
    }

    public function scopePdfChatId($query, $pdfChatId){
        $query->where('pdf_chat_id', $pdfChatId);
    }

}
