<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\AdSense;
use App\Models\Project;
use App\Traits\Language;
use App\Models\PWASettings;
use App\Models\MediaManager;
use App\Traits\SystemUpdate;
use Illuminate\Http\Request;
use App\Models\EmailTemplate;
use App\Models\SystemSetting;
use App\Traits\GenerateVoice;
use Faker\Generator as Faker;
use Orhanerday\OpenAi\OpenAi;
use App\Models\PaymentGateway;
use App\Models\WritebotModule;
use App\Models\ElevenLabsModel;
use App\Exports\CustomersExport;
use Illuminate\Support\Facades\DB;
use App\Models\SubscriptionHistory;
use Illuminate\Support\Facades\Log;
use Nwidart\Modules\Facades\Module;
use App\Http\Services\SerperService;
use App\Models\ElevenLabsModelVoice;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Support\Entities\Priority;
use Illuminate\Support\Facades\Artisan;
use App\Http\Services\ElevenLabsService;
use App\Http\Services\OpenAiCustomService;
use League\CommonMark\Normalizer\SlugNormalizer;
use App\Http\Controllers\Backend\Templates\TemplatesController;
use App\Http\Controllers\Backend\Payments\Paypal\PaypalController;

class TestController extends Controller
{
  //
  use Language;
  use GenerateVoice;
  use SystemUpdate;
  public function index(Faker $faker)
  {
  }
  /**
   * fact 1 : unlimited
   * fact 2 : customer check and available balance checking
   * fact 3 :request max token compare with available balance
   */
  public function test(Request $request)
  {
    SystemSetting::updateOrCreate(
      [
        'entity' => 'software_version'
      ],
      [
        'value' => "4.1.0"
      ]
    );

    SystemSetting::updateOrCreate(
      [
        'entity' => 'last_update'
      ],
      [
        'value' => Carbon::now()
      ]
    );
    cacheClear();
  }





  // baclup

  function migrate(Request $request)
  {
    if ($request->has('smartyCoder') && $request->smartyCoder == 'aminulislam') {
      Artisan::call('migrate');
      dd('Welcome! see you again');
    }
    dd('You are not a smarty coder');
  }
}
